# GalliumHash Automation Setup Guide

## 🎯 Overview
This guide shows how to set up automatic data collection and intelligence processing for all GalliumHash planets.

## 📋 Required Cron Jobs

Add these cron jobs to your cPanel **Cron Jobs** section:

### Master Scheduler (Recommended)
```bash
# Run master scheduler every 5 minutes (cPanel hosting optimized)
*/5 * * * * /usr/local/bin/ea-php81 /home/nvdaxcom/public_html/core.galliumhash.com/automation/master-scheduler.php run
```

**Notes:**
- Uses PHP 8.1 (ea-php81) as configured for core.galliumhash.com domain
- 5-minute interval for better monitoring and faster response
- Resource-optimized for cPanel shared hosting

### Individual Collectors (Alternative)
If you prefer individual control, add these cron jobs:

```bash
# MetaBuilder - Bitcoin data collection (every 10 minutes)
*/10 * * * * /usr/bin/php /path/to/core.galliumhash.com/automation/metabuilder-collector.php run

# MetaMiner - Intelligence processing (every 5 minutes)  
*/5 * * * * /usr/bin/php /path/to/core.galliumhash.com/automation/metaminer-processor.php run

# Ethereum GasCollector - Gas data collection (every 5 minutes)
*/5 * * * * /usr/bin/php /path/to/core.galliumhash.com/automation/ethereum-gas-collector.php run
```

### Health Monitoring (Optional)
```bash
# Health check every hour
0 * * * * /usr/bin/php /path/to/core.galliumhash.com/automation/master-scheduler.php health > /dev/null 2>&1
```

## 🔧 Setup Steps

### 1. Verify cPanel Cron Access
1. Log into your cPanel
2. Find **Cron Jobs** section
3. Check if you have access to add cron jobs

### 2. Set Full Paths
Replace `/path/to/core.galliumhash.com` with your actual path:
- **For cPanel hosting:** Usually `/home/username/public_html/core.galliumhash.com`
- **Check your actual path:** Look in cPanel File Manager

### 3. Test Each Component
```bash
# Test master scheduler
/usr/bin/php /path/to/core.galliumhash.com/automation/master-scheduler.php test

# Test individual components
/usr/bin/php /path/to/core.galliumhash.com/automation/metabuilder-collector.php test
/usr/bin/php /path/to/core.galliumhash.com/automation/metaminer-processor.php test
/usr/bin/php /path/to/core.galliumhash.com/automation/ethereum-gas-collector.php test
```

### 4. Monitor Logs
Check these log files for status:
- `/core.galliumhash.com/automation/logs/master-scheduler.log`
- `/core.galliumhash.com/automation/logs/metabuilder-collector.log`
- `/core.galliumhash.com/automation/logs/metaminer-processor.log`
- `/core.galliumhash.com/automation/logs/ethereum-gas-collector.log`

## 📊 System Health Check

```bash
# Check overall system health
/usr/bin/php /path/to/core.galliumhash.com/automation/master-scheduler.php health

# Check individual systems
/usr/bin/php /path/to/core.galliumhash.com/automation/metabuilder-collector.php health
/usr/bin/php /path/to/core.galliumhash.com/automation/metaminer-processor.php health
/usr/bin/php /path/to/core.galliumhash.com/automation/ethereum-gas-collector.php health
```

## ⚡ Expected Behavior

### Data Freshness Status
- **Fresh**: < 10 minutes old ✅
- **Aging**: 10-60 minutes old ⚠️
- **Stale**: > 60 minutes old 🔴

### Collection Intervals
- **MetaBuilder**: Every 10 minutes (Bitcoin data)
- **MetaMiner**: Every 5 minutes (Intelligence processing)
- **GasCollector**: Every 5 minutes (Ethereum gas data)

### Success Indicators
- Log files show `SUCCESS` messages
- Health checks return `healthy` status
- Data freshness shows `fresh` status
- No error messages in logs

## 🚨 Troubleshooting

### Common Issues

**Cron job not running**
```bash
# Check cron job exists
crontab -l

# Check file permissions
ls -la /path/to/core.galliumhash.com/automation/*.php

# Test manually
/usr/bin/php /path/to/core.galliumhash.com/automation/master-scheduler.php test
```

**Permission errors**
```bash
# Fix permissions
chmod +x /path/to/core.galliumhash.com/automation/*.php
chmod 755 /path/to/core.galliumhash.com/automation/
chmod 755 /path/to/core.galliumhash.com/automation/logs/
```

**Database connection errors**
- Check database credentials in `.env` file
- Verify database server is running
- Test database connection manually

**API rate limits**
- Reduce collection frequency if hitting limits
- Check API response codes in logs
- Increase delays between API calls

### Log Analysis
```bash
# Check latest entries
tail -f /path/to/core.galliumhash.com/automation/logs/master-scheduler.log

# Check for errors
grep -i error /path/to/core.galliumhash.com/automation/logs/*.log

# Check last successful run
grep -i "SUCCESS" /path/to/core.galliumhash.com/automation/logs/*.log | tail -5
```

## 🔒 Security Notes

- Cron jobs run as your hosting user
- Log files are stored in automation directory
- Environment variables are loaded from `.env` file
- All scripts include timeout protection
- No sensitive data in cron job commands

## 📈 Monitoring

Set up external monitoring to check:
1. Log file timestamps (recent activity)
2. Database data freshness
3. API endpoint responses
4. System health endpoints

## ✅ Verification Checklist

- [ ] Cron jobs added to cPanel
- [ ] All test scripts pass
- [ ] Log files are being created
- [ ] Data freshness shows `fresh` status
- [ ] No error messages in logs
- [ ] All three systems (MetaBuilder, MetaMiner, GasCollector) showing healthy status

---

## 🚀 Next Steps

After automation is working:

1. **Monitor for 24 hours** to ensure stability
2. **Review logs** for any performance issues
3. **Optimize intervals** based on your hosting limits
4. **Set up external monitoring** (if needed)
5. **Plan database optimization** (Phase 4)

**Your GalliumHash ecosystem will now run automatically! 🎉**